<?php
// Memuat template header
require_once '../app/views/templates/header.php';
?>

<!-- Konten Daftar Tutorial -->
<section class="max-w-4xl mx-auto bg-white p-8 rounded-xl shadow-lg border border-gray-100">
    <h1 class="text-3xl font-bold text-gray-900 mb-8 border-b pb-4 text-center">
        Panduan Lengkap Cara Transfer Pulsa
    </h1>

    <p class="text-gray-600 mb-6 text-center">
        Pilih operator Anda di bawah untuk melihat langkah-langkah transfer pulsa yang benar sebelum memulai konversi.
    </p>

    <!-- Daftar Tutorial -->
    <div class="space-y-4">

        <?php
        // Data Operator Statis (seharusnya diambil dari database melalui Model jika memungkinkan)
        $tutorial_list = [
            ['operator' => 'Tri (3)', 'key' => 'tri', 'description' => 'Langkah-langkah terbaru untuk mengirim pulsa ke nomor tujuan melalui operator Tri.'],
            ['operator' => 'XL / Axis', 'key' => 'xl', 'description' => 'Panduan lengkap transfer pulsa antar pengguna XL dan Axis.'],
            ['operator' => 'Telkomsel (Tsel)', 'key' => 'telkomsel', 'description' => 'Cara transfer pulsa Telkomsel via SMS atau dial up USSD.'],
            ['operator' => 'Indosat (IM3/Mentari)', 'key' => 'indosat', 'description' => 'Petunjuk mudah dan cepat untuk berbagi pulsa Indosat Ooredoo.'],
        ];

        foreach ($tutorial_list as $t):
        ?>
            <div class="border border-gray-200 p-4 rounded-lg bg-gray-50 hover:bg-white transition duration-200">
                <!-- Link ini akan memanggil method detail() di Tutorial Controller -->
                <a href="<?= BASEURL; ?>tutorial/detail/<?= $t['key']; ?>" class="flex justify-between items-center">
                    <span class="font-semibold text-xl text-primary hover:text-blue-700"><?= $t['operator']; ?></span>
                    <i class="fas fa-chevron-right text-gray-400"></i>
                </a>
                <p class="text-gray-500 text-sm mt-1"><?= $t['description']; ?></p>
            </div>
        <?php endforeach; ?>

    </div>

    <div class="mt-8 pt-4 border-t text-center">
        <a href="<?= BASEURL; ?>" class="inline-flex items-center text-accent font-semibold hover:text-amber-600">
            <i class="fas fa-arrow-left mr-2"></i> Kembali ke Halaman Utama
        </a>
    </div>
</section>

<?php
// Memuat template footer
require_once '../app/views/templates/footer.php';
?>