<?php
// Memuat template header
require_once '../app/views/templates/header.php';

// Pastikan data yang dibutuhkan tersedia
$operator_key = $data['operator'] ?? 'UNKNOWN';
$rate = $data['rate']['rate_value'] ?? 0.8; // Gunakan 0.8 sebagai rate default jika data tidak ada

// Data untuk ditampilkan di form
$min_nominal = 30000; // Contoh minimal nominal transfer
?>

<section class="max-w-xl mx-auto mt-10 p-6 bg-white rounded-2xl shadow-2xl border border-blue-100">

    <div class="text-center mb-6">
        <h1 class="text-3xl font-extrabold text-gray-900">
            Konversi Pulsa <span class="text-primary"><?= htmlspecialchars($operator_key); ?></span>
        </h1>
        <p class="text-gray-500 mt-2">
            Isi formulir di bawah ini untuk memulai konversi pulsa Anda.
        </p>
    </div>

    <!-- Tampilkan Rate Saat Ini -->
    <div class="bg-accent-light p-4 rounded-xl mb-6 text-center shadow-inner">
        <p class="text-sm text-gray-800 font-semibold">
            Rate Konversi Saat Ini: 
            <span class="text-lg font-extrabold text-accent">
                <?= number_format($rate * 100, 0); ?>%
            </span>
        </p>
        <p class="text-xs text-gray-600 mt-1">
            Artinya, dari Rp100.000 pulsa, Anda akan menerima Rp<?= number_format(100000 * $rate, 0, ',', '.'); ?>
        </p>
    </div>


    <!-- Form Transaksi -->
    <form action="<?= BASEURL; ?>konversipulsa/proses" method="POST" id="conversionForm">
        
        <!-- Field Tersembunyi (Operator) -->
        <input type="hidden" name="operator" value="<?= htmlspecialchars($operator_key); ?>">

        <!-- Nominal Pulsa -->
        <div class="mb-5">
            <label for="nominal" class="block text-sm font-medium text-gray-700 mb-2">
                Nominal Pulsa yang Ditransfer (Min. Rp<?= number_format($min_nominal, 0, ',', '.'); ?>)
            </label>
            <input type="number" name="nominal" id="nominal" min="<?= $min_nominal; ?>" required 
                   placeholder="Contoh: 50000" 
                   class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-primary focus:border-primary transition duration-150 shadow-sm"
                   oninput="hitungTerima(this.value, <?= $rate; ?>)">
            <p id="nominalError" class="text-red-500 text-sm mt-1 hidden">Nominal harus minimal Rp<?= number_format($min_nominal, 0, ',', '.'); ?></p>
        </div>
        
        <!-- Nominal Diterima (Hasil Perhitungan) -->
        <div class="mb-5 p-3 bg-green-50 border border-green-300 rounded-lg">
            <label class="block text-sm font-medium text-green-800 mb-1">
                Uang yang Diterima (Estimasi)
            </label>
            <p id="nominalDiterima" class="text-2xl font-bold text-green-700">
                Rp0
            </p>
        </div>
        
        <!-- Bank Tujuan -->
        <div class="mb-5">
            <label for="bank" class="block text-sm font-medium text-gray-700 mb-2">
                Pilih Bank Tujuan Transfer
            </label>
            <select name="bank" id="bank" required 
                    class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-primary focus:border-primary transition duration-150 shadow-sm">
                <option value="">-- Pilih Bank --</option>
                <option value="bca">BCA</option>
                <option value="mandiri">Mandiri</option>
                <option value="bni">BNI</option>
                <option value="bri">BRI</option>
                <option value="dana">DANA</option>
                <option value="gopay">GOPAY</option>
                <!-- Tambahkan bank atau e-wallet lain -->
            </select>
        </div>

        <!-- Nomor Rekening Tujuan -->
        <div class="mb-5">
            <label for="norek" class="block text-sm font-medium text-gray-700 mb-2">
                Nomor Rekening / E-Wallet Tujuan
            </label>
            <input type="text" name="norek" id="norek" required 
                   placeholder="Masukkan nomor rekening atau HP E-Wallet" 
                   class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-primary focus:border-primary transition duration-150 shadow-sm">
        </div>

        <!-- Nomor HP Pengirim Pulsa -->
        <div class="mb-6">
            <label for="nohp" class="block text-sm font-medium text-gray-700 mb-2">
                Nomor HP Pengirim Pulsa (Pastikan Benar)
            </label>
            <input type="tel" name="nohp" id="nohp" required 
                   placeholder="Contoh: 0812xxxxxxxx" 
                   class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-primary focus:border-primary transition duration-150 shadow-sm">
        </div>

        <!-- Tombol Submit -->
        <button type="submit" id="submitBtn" disabled
                class="w-full bg-primary hover:bg-blue-700 text-white font-bold py-3 px-4 rounded-lg transition duration-200 shadow-md disabled:bg-gray-400">
            PROSES KONVERSI SEKARANG
        </button>
        
        <p class="text-xs text-center text-gray-500 mt-3">
            Dengan menekan tombol ini, Anda menyetujui <a href="#" class="text-primary hover:underline">Syarat & Ketentuan</a> kami.
        </p>
    </form>
</section>

<!-- Script Khusus untuk Form Konversi -->
<script>
    // Pastikan fungsi ini ada di script.js atau didefinisikan di sini.
    // Kita buat ulang di sini untuk memastikan fungsi perhitungan nominal berjalan
    const minNominal = <?= $min_nominal; ?>;
    const nominalInput = document.getElementById('nominal');
    const nominalDiterima = document.getElementById('nominalDiterima');
    const submitBtn = document.getElementById('submitBtn');
    const nominalError = document.getElementById('nominalError');

    function hitungTerima(nominal, rate) {
        let nominalValue = parseInt(nominal) || 0;
        let diterima = nominalValue * rate;
        
        nominalDiterima.textContent = 'Rp' + diterima.toLocaleString('id-ID', {minimumFractionDigits: 0});
        
        // Validasi dan aktifkan tombol
        if (nominalValue >= minNominal) {
            submitBtn.disabled = false;
            nominalError.classList.add('hidden');
        } else {
            submitBtn.disabled = true;
            if (nominalValue > 0) {
                 nominalError.classList.remove('hidden');
            } else {
                 nominalError.classList.add('hidden');
            }
        }
    }

    // Panggil fungsi saat halaman dimuat
    nominalInput.addEventListener('input', () => hitungTerima(nominalInput.value, <?= $rate; ?>));

    // Panggil sekali untuk inisialisasi
    hitungTerima(nominalInput.value, <?= $rate; ?>);
</script>

<?php
// Memuat template footer
require_once '../app/views/templates/footer.php';
?>