<?php

// Pastikan sesi dimulai di awal aplikasi
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// ------------------------------------------
// PENGATURAN UMUM APLIKASI
// ------------------------------------------

// Base URL (sesuaikan dengan URL proyek Anda)
// Contoh: http://localhost/nama_project_anda/
define('BASEURL', 'http://localhost/nama_project_anda/'); 

// Nama Aplikasi
define('APP_NAME', 'Convert Pulsa App');


// ------------------------------------------
// PENGATURAN DATABASE (MySQL/SQL)
// ------------------------------------------

define('DB_HOST', 'localhost');
define('DB_USER', 'root');      
define('DB_PASS', 'root');          
define('DB_NAME', 'blog_sb'); 

// Konfigurasi Timezone
date_default_timezone_set('Asia/Jakarta');

// Mengaktifkan mode error reporting saat pengembangan (ubah ke 0 saat deployment)
ini_set('display_errors', 1);
error_reporting(E_ALL);


// ------------------------------------------
// OTOMATIS MEMUAT FILE INTI (CORE & MODELS)
// Semua file berada di luar folder public, jadi harus menggunakan '../'
// ------------------------------------------

// Memuat Model Dasar (Koneksi Database)
require_once '../app/models/Database.php'; 

// Memuat Core Components
require_once '../app/core/Controller.php'; // Base Controller untuk semua Controller
require_once '../app/core/App.php';        // Core Router
require_once '../app/core/Helper.php';     // Fungsi-fungsi pembantu

?>