<?php

// Class ini mengurus data terkait pengguna, seperti login dan registrasi.
class UserModel {
    private $db;
    private $table = 'users';

    public function __construct() {
        $this->db = new Database;
    }

    // Mencari pengguna berdasarkan username dan memverifikasi password
    public function checkUserCredentials($username, $password) {
        $this->db->query('SELECT * FROM ' . $this->table . ' WHERE username = :user');
        $this->db->bind('user', $username);
        $user = $this->db->single();

        // Jika user ditemukan, verifikasi password
        if ($user) {
            // Asumsi password disimpan dengan hash (Wajib menggunakan password_hash() dan password_verify())
            if (password_verify($password, $user['password_hash'])) {
                // Password benar
                return $user;
            }
        }
        
        // User tidak ditemukan atau password salah
        return false;
    }
    
    // Menyimpan data pengguna baru (Registrasi)
    public function registerUser($data) {
        // Mengamankan password dengan hashing (WAJIB)
        $hashedPassword = password_hash($data['password'], PASSWORD_DEFAULT);

        $query = "INSERT INTO " . $this->table . " 
                  (username, email, password_hash, created_at)
                  VALUES 
                  (:user, :email, :pass, NOW())";

        $this->db->query($query);
        
        $this->db->bind('user', $data['username']);
        $this->db->bind('email', $data['email']);
        $this->db->bind('pass', $hashedPassword);
        
        $this->db->execute();

        return $this->db->rowCount();
    }

    // Mengambil data pengguna berdasarkan ID
    public function getUserById($id) {
        $this->db->query('SELECT id, username, email FROM ' . $this->table . ' WHERE id = :id');
        $this->db->bind('id', $id);
        return $this->db->single();
    }
}