<?php

// Class ini mengurus data terkait rate, operator, dan transaksi konversi pulsa.
class KonversiModel {
    private $db;
    private $tableRates = 'rates';
    private $tableTransactions = 'transactions';

    public function __construct() {
        // Membuat instance koneksi database
        $this->db = new Database;
    }

    // Mengambil semua data rate dan operator
    public function getAllRates() {
        $this->db->query('SELECT * FROM ' . $this->tableRates . ' WHERE is_active = 1 ORDER BY operator_name ASC');
        return $this->db->resultSet();
    }

    // Mengambil rate spesifik berdasarkan nama operator
    public function getRateByOperator($operator) {
        $this->db->query('SELECT * FROM ' . $this->tableRates . ' WHERE operator_slug = :op AND is_active = 1');
        $this->db->bind('op', $operator);
        return $this->db->single();
    }

    // Menyimpan data transaksi baru ke database
    public function createTransaction($data) {
        
        // Asumsi kita sudah punya rate (misalnya 0.80)
        $rateData = $this->getRateByOperator($data['operator']);
        
        if (!$rateData) {
            // Rate tidak ditemukan
            return false;
        }

        $rate = $rateData['rate_value'];
        $nominal = (int)$data['nominal'];
        
        // Hitung uang yang diterima
        $amountReceived = $nominal * $rate;
        
        // Query INSERT
        $query = "INSERT INTO " . $this->tableTransactions . " 
                  (operator, nominal_pulsa, rate, amount_received, norek_tujuan, status)
                  VALUES 
                  (:op, :nom, :rate, :amount, :norek, :status)";

        $this->db->query($query);

        // Binding parameter
        $this->db->bind('op', $data['operator']);
        $this->db->bind('nom', $nominal);
        $this->db->bind('rate', $rate);
        $this->db->bind('amount', $amountReceived);
        $this->db->bind('norek', $data['norek']);
        $this->db->bind('status', 'PENDING'); // Status awal
        
        // Eksekusi query
        $this->db->execute();

        // Mengembalikan ID transaksi yang baru dibuat
        return $this->db->lastInsertId();
    }

    // Mengambil detail transaksi berdasarkan ID
    public function getTransactionById($id) {
        $this->db->query('SELECT * FROM ' . $this->tableTransactions . ' WHERE id = :id');
        $this->db->bind('id', $id);
        return $this->db->single();
    }
}