<?php

class KonversiPulsa extends Controller {

    // Method untuk menampilkan form konversi setelah memilih operator
    // Contoh URL: BASEURL/konversipulsa/form/tri
    public function form($operator = null)
    {
        if (empty($operator)) {
            // Redirect atau tampilkan pesan error jika operator tidak dipilih
            header('Location: ' . BASEURL);
            exit;
        }

        $konversiModel = $this->model('KonversiModel');
        
        // Ambil data rate spesifik untuk operator yang dipilih
        $data['operator'] = strtoupper($operator);
        $data['rate'] = $konversiModel->getRateByOperator($operator); 
        
        $data['title'] = 'Konversi ' . $data['operator'];

        // Tampilkan form (views/transaksi/form.php)
        $this->view('transaksi/form', $data);
    }

    // Method untuk memproses data yang dikirim dari form konversi (POST request)
    public function proses()
    {
        // Pastikan ini adalah POST request
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            header('Location: ' . BASEURL);
            exit;
        }

        $konversiModel = $this->model('KonversiModel');

        // Sanitisasi dan validasi data input dari $_POST
        $data_input = [
            'operator' => filter_input(INPUT_POST, 'operator', FILTER_SANITIZE_STRING),
            'nominal' => filter_input(INPUT_POST, 'nominal', FILTER_SANITIZE_NUMBER_INT),
            'norek' => filter_input(INPUT_POST, 'norek', FILTER_SANITIZE_STRING)
            // Tambahkan field lain seperti no HP pengirim, bank tujuan, dll.
        ];

        // Contoh validasi sederhana
        if (empty($data_input['operator']) || empty($data_input['nominal'])) {
            // Set session flash message untuk error
            $this->view('error/400'); // Tampilkan halaman error atau pesan
            return;
        }

        // Simpan data transaksi ke database
        $transaksi_id = $konversiModel->createTransaction($data_input);

        if ($transaksi_id) {
            // Transaksi berhasil disimpan, arahkan ke halaman konfirmasi
            header('Location: ' . BASEURL . '/transaksi/konfirmasi/' . $transaksi_id);
        } else {
            // Gagal menyimpan transaksi
            $this->view('error/db_error');
        }
    }
}