<?php

class Home extends Controller {

    // Method default (saat tidak ada path lain yang ditentukan, e.g., BASEURL/)
    public function index()
    {
        // 1. Memuat Model (misalnya untuk mengambil data rate)
        $rateModel = $this->model('KonversiModel');

        // 2. Mendapatkan data yang dibutuhkan dari Model
        // Contoh: Ambil daftar operator dan rate mereka
        $data['rates'] = $rateModel->getAllRates();

        // Data lain yang mungkin dibutuhkan di Home View
        $data['title'] = 'Home - ' . APP_NAME;
        $data['pemberitahuan'] = 'Hanya menerima pulsa legal. Harap patuhi aturan yang ada.';
        
        // 3. Memuat View
        // Home/index akan memuat file views/home/index.php
        $this->view('home/index', $data);
    }

    // Contoh method lain: menampilkan detail rate terbaru
    public function detailRate()
    {
        // Tampilkan halaman khusus rate
        $this->view('rate/detail');
    }
}